%planet_projectile settings

%% Initial values of variable parameters %%
d.launch_lat = 45;    %Launch latitude /deg
d.launch_long = 0;    %Launch longitude /deg
d.v0 = 9e3;           %Launch speed /ms^-1
d.launch_elev = 30;   %Launch elevation /deg
d.launch_azi = 30;    %Launch azimuth (from 'East')

%Angular deviations
d.dlatlong = 0.5; d.delevazi = 0.5;

%Launch velocity change /ms^-1
d.dv0 = 100;

%Set planet texturemap file
planet = 'earth.jpg';

%

%% Hard coded inputs %%
d.M = 5.972e24;       %Planet mass /kg
d.R = 6371e3;         %Planet radius /m
d.T = 24*3600;        %Rotation period of planet /s
d.G = 6.67e-11;       %Universal Gravitational constant (N m^2 kg^-2 )
d.tmax = 2*24*3600;   %Maximum trajectory time
d.dt = 10;            %Timestep /s
d.fsize = 14;         %Fontsize

%

%Initial trajectory computation and render

%Calculate escape velocity /ms^-1
v_escape = sqrt( 2*d.G*d.M/d.R );